% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program PowerAnalysis1.m
function beta = PowerAnalysis(effectSize, sampleSize, alpha)
  
xi = 0.50;
lamda = 0.02;
tau1 =  0.0112;                         % unattended
eta1 = 2.84;
tau2 =  0.0112 * 10 ^ (-effectSize/20); % attended
eta2 = 2.84;
totalN=1000;

% placement of stimulus contrast
p0 = [0.53 0.59 0.65 0.75 0.85 0.91 0.97];
c_pre = ((-1)*log((1 - lamda - p0)./(1 - lamda - ...
      xi))).^(1/eta1)*tau1;
c_post = ((-1)*log((1 - lamda - p0)./(1 - lamda - ...
      xi))).^(1/eta2)*tau2;

success = 0;
for i = 1 : totalN
    PFS(1, 1:7) = c_pre;
    PFS(2:3, 1:7) = 0;
    for j = 1 : 7
        prob = xi + (1 - xi - lamda) * (1 - exp(-...
              (c_pre(j)/tau1).^eta1));
        for k = 1 : sampleSize
            r = rand;
            if r < prob
                PFS(2, j) = PFS(2, j) + 1;
            else
                PFS(3, j) = PFS(3, j) + 1;
            end
        end
    end
                
    PFS(4, 1:7) = c_post;
    PFS(5:6, 1:7) = 0;
    for j = 1 : 7
        prob = xi + (1 - xi - lamda) * (1 - exp(- ...
              (c_post(j)/tau2).^eta2));
        for k = 1 : sampleSize
            r = rand;
            if r < prob
                PFS(5, j) = PFS(5, j) + 1;
            else
                PFS(6, j) = PFS(6, j) + 1;
            end
        end
    end
    
    NPF = 2;

    % full model fit
    data = PFS;
    guess = [0.01 0.01*10^(effectSize/20) 3];
    options = optimset('fminsearch');
    [psy, minus_maxloglikelihood] = ...
       fminsearch('Weibullcostfunc1', guess, options, data);
    fullmodel_maxloglikelihood = - minus_maxloglikelihood;
    
    %reduced model
    data = PFS;
    guess = [(0.01+0.01*10^(effectSize/20))/2 3];
    options = optimset('fminsearch');
    [psy, minus_maxloglikelihood] = ...
       fminsearch('Weibullcostfunc2', guess, options, data);
    reducedmodel_maxloglikelihood = ...
       - minus_maxloglikelihood;
 
    chi2 = 2*(fullmodel_maxloglikelihood - ...
       reducedmodel_maxloglikelihood);
    p = 1 - chi2cdf(chi2, 1);
    if p < alpha
        success = success + 1;
    end
end
beta = success/totalN;
        
